var isCollapsed = true;

function animate() {
    var T;
    var ease;
    var time = (new Date).getTime();
		
    T = limit_3(time-animation.starttime, 0, animation.duration);
	
    if(T >= animation.duration) {
        clearInterval (animation.timer);
        animation.timer = null;
        animation.now = animation.to;
    } else {
        ease = 0.5 - (0.5 * Math.cos(Math.PI * T / animation.duration));
        animation.now = computeNextFloat (animation.from, animation.to, ease);
    }
	
    animation.firstElement.style.opacity = animation.now;
}

function resizeAnimateDiv() {
	var T;
	var ease;
	var time  = (new Date).getTime();
	var yLoc;
	var frame;
		
	T = limit_3(time-resizeAnimation.startTime, 0, resizeAnimation.duration);
	ease = 0.5 - (0.5 * Math.cos(Math.PI * T / resizeAnimation.duration));

	if(T >= resizeAnimation.duration) {
		yLoc = resizeAnimation.positionTo;
		clearInterval (resizeAnimation.timer);
		resizeAnimation.timer = null;
		
		if (resizeAnimation.onfinished)
			setTimeout ("resizeAnimation.onfinished();", 0);
	} else {
		yLoc = computeNextFloat(resizeAnimation.positionFrom, resizeAnimation.positionTo, ease);
    }
		
	resizeAnimation.positionNow = parseInt(yLoc);
	resizeAnimation.element.style.height = resizeAnimation.positionNow + "px";
} 

function limit_3(a, b, c) {
    return a < b ? b : (a > c ? c : a);
}

function computeNextFloat(from, to, ease) {
    return from + (to - from) * ease;
}

function createkey(key) {
	return widget.identifier + "-" + key;
}

function calculateBackgroundHeight() {
	var height;
	if(isCollapsed)
		height = 74;
	else
		height = 296;

    return height;
} 

function animFinished() {
	if (window.widget) {
		if(isCollapsed) {
			totalWidgetHeight = calculateBackgroundHeight();
			window.resizeTo(326, totalWidgetHeight);
		}
	}
}

var resizeAnimation = {startTime:0, duration:250, positionFrom:0, positionTo:0, positionNow:0, frameFrom:0, frameTo:0, frameNow:0, timer:null, element:null, image:null, background:null, onfinished:null};

function toggleView(event, element) {
    var helperDiv = document.getElementById(element);
    var timeNow = (new Date).getTime();
    var multiplier = 1.2;
    var startingSize = parseInt(helperDiv.clientHeight,10);

    resizeAnimation.element = helperDiv;
    if(resizeAnimation.timer != null) {
        clearInterval(resizeAnimation.timer);
        resizeAnimation.timer = null;
        resizeAnimation.duration -= (timeNow - resizeAnimation.startTime);
        resizeAnimation.positionFrom = resizeAnimation.positionNow;
    } else {
        resizeAnimation.duration = 250 * multiplier;
        resizeAnimation.positionFrom = startingSize;
    }
    
    isCollapsed = !isCollapsed;
    var resizeTo = isCollapsed ? 0 : 226;
    totalWidgetHeight = calculateBackgroundHeight();
    
    if(!isCollapsed && window.widget)
        window.resizeTo(326, totalWidgetHeight);

    resizeAnimation.positionTo = parseInt(resizeTo);
    resizeAnimation.startTime = timeNow - 13;
    resizeAnimation.onfinished = animFinished;
    
    resizeAnimation.element.style.height = startingSize;
    resizeAnimation.timer = setInterval("resizeAnimateDiv();", 13);
    resizeAnimateDiv();
}